#ifndef __FARC_H
#define __FARC_H


/* BEGIN HEADER ===============================================================

	 Project:        Arcnet-Treiber for Windows NT
	 Programname:    -
	 Modulname:      -
	 Filename:       FARC.H

	 Description:    Provides constants and types for the application
                     that uses the FARC-driver

	 Global Subroutines: -
	 Import:         -
	 Export:         -

	 Current Version:  7.0
	 Created:          05.12.1996

	 Company:          SOHARD Embedded Systems GmbH, Fuerth

	(c) SOHARD Embedded Systems GmbH 1996-2012 All rights reserved
** END HEADER   =============================================================*/

/* ------------------ COMPILER CONTROLS  ------------------*/

/* ------------------      INCLUDES       ------------------*/
#ifndef INITGUID
    #include <initguid.h>
#endif
/* ------------------    DEFINITIONS      ------------------*/

// SOHARD Arcnet Interface GUID {A9C9D516-83FB-11d4-9BA7-0050046AA221}
DEFINE_GUID(GUID_SOHARD_ARC_INTERFACE, 0xa9c9d516, 0x83fb, 0x11d4, 0x9b, 0xa7, 0x0, 0x50, 0x4, 0x6a, 0xa2, 0x21);


#ifdef TARGET_8051
#define E_FARC_ERROR_CODE_OFFSET           0
#else
#define E_FARC_ERROR_CODE_OFFSET           0xE00503A8L
#endif

#ifndef TARGET_8051
// Operation not successful
// Driver is currently not started
//      CreateFile
#define E_FARC_DRIVER_NOT_STARTED       2L

// invalid handle
// relevant functions: 
//      ReadFile, ReadFileEx, WriteFile, WriteFileEx, DeviceIoControl,
//      CloseFile
#define E_FARC_INVALID_HANDLE            6L

// Read-Operation aborted due to Init/Deinit
// Read-Request returns with invalid buffer
// IOCTL_FARC_GET_NETMAP aborted due to Init/Deinit
// relevant functions: 
//      ReadFile, ReadFileEx, DeviceIoControl IOCTL_FARC_GET_NETMAP
#define E_FARC_ABORT                    995L

// Request pending
#define E_FARC_INCOMPLETE                996L

// Request pending
#define E_FARC_PENDING                   997L
#endif


// IOCTL-number not supported
// relevant functions: 
//      DeviceIoControl
#define E_FARC_DRIVER_OPTION             (E_FARC_ERROR_CODE_OFFSET + 1L)

// no token seen
// relevant functions: 
//      DeviceIoControl
#define E_FARC_NO_TOKEN                  (E_FARC_ERROR_CODE_OFFSET + 8L)

// read-request or write-request not accepted due to uninitialized Controller
// (DeviceIoControl(IOCTL_FARC_INIT) not yet proceeded)
// relevant functions: 
//      ReadFile, ReadFileEx, WriteFile, WriteFileEx
#define E_FARC_NOT_INITED               (E_FARC_ERROR_CODE_OFFSET + 18L)

// excessive reconfiguration occures, Write-Request/Read-Request denied
// relevant functions: 
//      ReadFile, ReadFileEx, WriteFile, WriteFileEx
#define E_FARC_EXCESSIVE_RECON           (E_FARC_ERROR_CODE_OFFSET + 21L)

// buffer too small
#define E_FARC_BUFFER_TOO_SMALL          (E_FARC_ERROR_CODE_OFFSET + 22L)

// wrong parameters in dcb 
// (for Ex.: b_init_behaviour = 4)
#define E_FARC_NO_PARAMETERS            (E_FARC_ERROR_CODE_OFFSET + 23L)

// invalid packet-length
//     Write: packet-length (netto) between 253 and 256 or
//            greater than 508 or 
//            less than 0 (less than 7 Bytes in buffer)
//      Read: buffer-size less than 514
// relevant functions: 
//      ReadFile, ReadFileEx, WriteFile, WriteFileEx
#define E_FARC_BAD_PACKET_SIZE           (E_FARC_ERROR_CODE_OFFSET + 24L)

// no bus activity
// relevant functions: 
//      DeviceIoControl
#define E_FARC_NO_ACTIVITY               (E_FARC_ERROR_CODE_OFFSET + 29L)

// more than 5 Read/Write-Requests executed (Demo-Mode only)
#define E_FARC_USAGE_EXPIRED             (E_FARC_ERROR_CODE_OFFSET + 30L)

// IOCTL_FARC_ENABLE_RECEIVE not allowed. because disable just performing
#define E_FARC_PERFORMING_DISABLE        (E_FARC_ERROR_CODE_OFFSET + 31L)

// IOCTL_FARC_ENABLE_RECEIVE not allowed. all pages are enabled
// no IOCTL_FARC_DISABLE_RECEIVE previously performed
#define E_FARC_NO_DISABLE                (E_FARC_ERROR_CODE_OFFSET + 32L)

// Read Timeout occured
#define E_FARC_READ_TIMEOUT				 (E_FARC_ERROR_CODE_OFFSET + 34L)

// wrong SID in send-packet
#define E_FARC_BAD_SID                   (E_FARC_ERROR_CODE_OFFSET + 37L)

// no node set for checking in IOCTL_FARC_NETMAP_SETTINGS
#define E_FARC_NETMAP_ERROR				 (E_FARC_ERROR_CODE_OFFSET + 45L)

// GET_NETMAP just pending
#define E_FARC_NETMAP_PENDING			 (E_FARC_ERROR_CODE_OFFSET + 46L)

// No netmap change detected
#define E_FARC_NETMAP_NO_CHANGE			 (E_FARC_ERROR_CODE_OFFSET + 47L)

// nodeaddress exists
#define E_FARC_DUPID                     (E_FARC_ERROR_CODE_OFFSET + 52L)

// no response from receiver
// relevant functions: 
//      WriteFile, WriteFileEx
#define E_FARC_NO_RESPONSE               (E_FARC_ERROR_CODE_OFFSET + 55L)

// long packets not supported by receiver (20020, 20020C, 20019, 20022 only)
// relevant functions: 
//      WriteFile, WriteFileEx
#define E_FARC_NO_LONG_PACKETS           (E_FARC_ERROR_CODE_OFFSET + 56L)

// initialization with inactive transmitter
#define E_FARC_PASSIVE_INIT              (E_FARC_ERROR_CODE_OFFSET + 57L)

// Init forced with no activity or no token on Bus!!
#define E_FARC_INIT_FORCED               (E_FARC_ERROR_CODE_OFFSET + 58L)

// no new-next-id received while initializing
// relevant functions: 
//      DeviceIoControl
#define E_FARC_NO_NEXTID                 (E_FARC_ERROR_CODE_OFFSET + 59L)

// No Tx-Pages available, Writerequest denied  
#define E_FARC_WRITE_DENIED              (E_FARC_ERROR_CODE_OFFSET + 61L)

// NAK received (4 or 128 NAKs, depends on initialization)
// relevant functions: 
//      WriteFile, WriteFileEx
#define E_FARC_NAK_TX                    (E_FARC_ERROR_CODE_OFFSET + 70L)

// read-request or write-request not accepted due to running initialization
// relevant functions: 
//      ReadFile, ReadFileEx, WriteFile, WriteFileEx
#define E_FARC_INITIALIZING             (E_FARC_ERROR_CODE_OFFSET + 71L)

// wrong parameter-mix in dcb:
// f.Ex.: NodeID = 0, 
// or ckp1, ckp2 and ckp3 = TRUE
// or ckp1, ckp3 = TRUE and Clock (in registry) = 20
// relevant functions: 
//      DeviceIoControl
#define E_FARC_BAD_PARAMETER             (E_FARC_ERROR_CODE_OFFSET + 87L)

// IOCTL_FARC_XXXX-Constants **********************************************************
// Device Type
#ifndef ARC_TYPE
#define ARC_TYPE FILE_DEVICE_CONTROLLER
#endif

#ifndef __FARC_IOCTL
#define __FARC_IOCTL

// define the function numbers for IOCTL codes
#define _GET_SWVERSION				3
#define _GET_CARDID					4
#define _INIT						5
#define _GET_USEDDCB				6
#define _GET_NETSTATE				7
#define _GET_NEXTNODEID				8
#define _GET_INTERRUPTS				9
#define _DEINIT						10
#define _GET_RXSTATUS				11
#define _DISABLE_RECEIVE			12
#define _ENABLE_RECEIVE				13
#define _GET_EXTNODEID				14
#define _EXTND_FUNCTIONS			15
#define _CANCEL_IO					16
#define _NETMAP_SETTINGS			17
#define _GET_NETMAP					18
#define _GET_RESOURCE_USAGE			19
#define _SET_READ_TIMEOUT 			20
#define _GET_READ_TIMEOUT			21
#define _GET_HW_VERSIONS			22
#define _ARC_TRANSMITTER_CTRL		23
#define _GET_RECONS					24


#define _GET_SERIAL_NUMBER			254

#ifndef TARGET_8051
#define IOCTL_FARC_GET_SWVERSION		CTL_CODE(ARC_TYPE, _GET_SWVERSION,  METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_CARDID			CTL_CODE(ARC_TYPE, _GET_CARDID,  METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_INIT					CTL_CODE(ARC_TYPE, _INIT,  METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_USEDDCB			CTL_CODE(ARC_TYPE, _GET_USEDDCB,  METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_NETSTATE			CTL_CODE(ARC_TYPE, _GET_NETSTATE,  METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_NEXTNODEID		CTL_CODE(ARC_TYPE, _GET_NEXTNODEID,  METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_INTERRUPTS		CTL_CODE(ARC_TYPE, _GET_INTERRUPTS,  METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_DEINIT				CTL_CODE(ARC_TYPE, _DEINIT, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_RXSTATUS			CTL_CODE(ARC_TYPE, _GET_RXSTATUS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_DISABLE_RECEIVE		CTL_CODE(ARC_TYPE, _DISABLE_RECEIVE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_ENABLE_RECEIVE		CTL_CODE(ARC_TYPE, _ENABLE_RECEIVE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_EXTNODEID		CTL_CODE(ARC_TYPE, _GET_EXTNODEID, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_EXTND_FUNCTIONS		CTL_CODE(ARC_TYPE, _EXTND_FUNCTIONS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_CANCEL_IO			CTL_CODE(ARC_TYPE, _CANCEL_IO, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_NETMAP_SETTINGS		CTL_CODE(ARC_TYPE, _NETMAP_SETTINGS, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_NETMAP			CTL_CODE(ARC_TYPE, _GET_NETMAP, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_RESOURCE_USAGE   CTL_CODE(ARC_TYPE, _GET_RESOURCE_USAGE, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_SET_READ_TIMEOUT 	CTL_CODE(ARC_TYPE, _SET_READ_TIMEOUT, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_READ_TIMEOUT		CTL_CODE(ARC_TYPE, _GET_READ_TIMEOUT, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_HW_VERSIONS		CTL_CODE(ARC_TYPE, _GET_HW_VERSIONS, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_FARC_ARC_TRANSMITTER_CTRL	CTL_CODE(ARC_TYPE, _ARC_TRANSMITTER_CTRL, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_FARC_GET_RECONS			CTL_CODE(ARC_TYPE, _GET_RECONS, METHOD_BUFFERED, FILE_ANY_ACCESS)


#define IOCTL_FARC_GET_SERIAL_NUMBER	CTL_CODE(ARC_TYPE, _GET_SERIAL_NUMBER, METHOD_BUFFERED, FILE_ANY_ACCESS)
#endif

#endif

/* ------------------     CONSTANTS      ------------------*/

/* ------------------ TYPE-DECLARATIONS  ------------------*/

#ifndef __FARC_TYPES
#define __FARC_TYPES

typedef union {
	unsigned char ba[2];		// ba - byte array
	unsigned short w;		// w - word
} U_WORD;


// Initialization behaviors that can defined via DCB (see below)
//	WARNING:	eARC_INIT_FORCE can cause problems on the net, if connecting to
//				a running arcnet-Network with a defective arcnet-card)
#define eARC_INIT_BREAK		0	// Init will break, if no token seen or if no activity on bus
#define eARC_INIT_FORCE		1	// Init forced, if no token seen or if no activity on bus
#define eARC_INIT_PASSIVE	2	// initialize, the card but not enable transmitter



// DCB-structure (delivery: IOCTL_FARC_INIT + IOCTL_FARC_GET_USEDDCB)
// sizeof whole struct must be 16 Bytes!!
typedef struct s_ARCNET_DCB {
// Nodeadress of own Node in Arcnet-Network
// Must NOT be 0 !
	unsigned char   b_node_id;

// z_et_1, z_et_2, z_et_3 applies directly to ET1, ET2 und ET3
// in the CONFIG-/SETUP-Register of the arcnetcontroller.
// Sets the responsetime.
// The responsetime of all nodes in the network should be the same.
	unsigned char   z_et_1;
	unsigned char   z_et_2;
	unsigned char   z_et_3;

// z_ckp_1, z_ckp_2, z_ckp_1 applies directly to CKP1, CKP2 und CKP3
// in the SETUP-register of the arcnetcontroller.
// Sets the Bus-Speed. (All 0: 2.5Mbs)
	unsigned char   z_ckp_1;
	unsigned char   z_ckp_2;
	unsigned char   z_ckp_3;

// z_backplane applies directly to BACKPLANE in the CONFIG-register
// of the arcnetcontroller, use only with RS485 Interface
	unsigned char   z_backplane;

// z_p1mode applies directly to P1MODE in the SETUP-register
// of the arcnetcontroller, use only with RS485 Interface
	unsigned char   z_p1mode;

// z_fournaks applies directly to FOURNAKS in the SETUP-register
// of the arcnetcontroller
// If set to 1, it will cause the EXNACK condition to be set after 4 NAKs
// are detected.
// If set to 0, the EXNAK condition will be set after 128 NAKs.
	unsigned char   z_four_naks;

	unsigned char   b_reserved1[2];      // Do NOT use or modify!!

// see values description for more details
	unsigned char   b_init_behaviour;

	unsigned char   b_reserved2[3];      // Do NOT use or modify!!
} ARCNET_DCB;

// Netstate-structure (delivery: IOCTL_FARC_GET_NETSTATE)
typedef struct s_ARCNET_NETSTATE{
	unsigned char	z_token_seen;
	unsigned char	z_net_activity;
	unsigned char	z_txen;
} ARCNET_NETSTATE;

// extended structure (delivery: IOCTL_FARC_EXTND_FUNCTIONS)
typedef struct s_ARCNET_EXTND {
// z_ckup_0, z_ckup_1 applies directly to CKUP0, CKUP1
// in the SETUP2-Register of the arcnetcontroller 20022.
// Sets the Clock multiplier.
	unsigned char   z_ckup_0;
	unsigned char   z_ckup_1;

// z_rcntm_0, z_rcntm_1 applies directly to RCNTM0, RCNTM1
// in the SETUP2-Register of the arcnetcontroller 20022.
	unsigned char   z_rcntm_0;
	unsigned char   z_rcntm_1;

// enable/disable mode "Receive All"
	unsigned char	z_receiveall;

// reserved for future use (must currently set to 0)
	unsigned char   b_reserved[11];     // Do NOT use or modify!! 
} ARCNET_EXTND;

// Netmap settings/query structure 
// (delivery: IOCTL_FARC_NETMAP_SETTINGS)
// (delivery: IOCTL_FARC_GET_NETMAP)
typedef struct s_ARCNET_NETMAP {
	unsigned char	ba_netmap[32];  // netmap
									// ba_netmap[0]: Node 0..7
									// ba_netmap[1]: Node 8..15
									// ...
									// ba_netmap[31] Node 248..255
									// Bit0 (LSB) corresponds with least significant node
									// i.e.: (ba_netmap[1] & 0x10) addresses node 12
	unsigned short	w_timeout;      // 10ms units
} ARCNET_NETMAP;

// following structure describes hardware and firmware versions
// NOTE: if version does not exist it returns 0 
typedef struct _S_HW_VERSIONS {
	unsigned char baSN[8];
	U_WORD uHardware;
	U_WORD uFirmware;
} S_HW_VERSIONS, *PS_HW_VERSIONS;

#endif //__FARC_TYPES


/* ------------------ MODULGLOBAL VARIABLES ---------------*/

/* ------------------  EXTERNAL VARIABLES ------------------*/

/* ------------------  EXTERNAL FUNCTIONS ------------------*/

/* ------------------  INTERNAL FUNCTIONS ------------------*/

#endif
